/* 
 * File:   ImageDecoder.hpp
 * Author: yuri
 *
 * Created on June 13, 2011, 1:32 PM
 */

#ifndef IMAGEDECODER_HPP
#define	IMAGEDECODER_HPP

#include <vector>
#include "Triple.hpp"
using namespace std;

typedef Triple<int,int,int> coord3D_t;
typedef vector< coord3D_t > layer_t;
typedef layer_t path_t;
typedef vector<layer_t*> image_t;


class ImageDecoder {
public:
    ImageDecoder();
    ImageDecoder(const ImageDecoder& orig);
    virtual ~ImageDecoder();
    bool load(const char *file);
    int decodeLZMA(unsigned char *compr_data, int length, unsigned char **out,  unsigned int *outlength);
    image_t* getImage() const {
        return image;
    }
    int width, height;
private:
    image_t *image;

    void addPoint(char point, int &x, int &y, int &r, path_t *path);


};

#endif	/* IMAGEDECODER_HPP */

